<?php

namespace UtillzCore\Inc\Src\Admin\Http\Endpoints;

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Validation;
use \UtillzCore\Inc\Src\User;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Endpoint_Signin_Facebook extends Endpoint {

	public $action = 'utillz-signin-facebook';

    public function action() {

		$request = Request::instance();

		// if( ! wp_verify_nonce( $request->get('security'), 'ajax-nonce' ) ) {
		// 	return;
		// }

		$validation = new Validation();
		$response = $validation->validate( $request->params, [
			'id' => 'required',
			// 'email' => 'email',
			'first_name' => 'required',
			'last_name' => 'required',
		]);

		if( $response->success ) {

			$user_id = User::create([
				'user_login' => $request->get('id'),
	            'user_email' => $request->get('email'),
	            'user_pass' => md5( $request->get('id') . get_option('ulz_facebook_app_secret') ),
	            'first_name' => $request->get('first_name'),
	            'last_name' => $request->get('last_name')
			]);

			if( $user_id ) {

				update_user_meta( $user_id, 'ulz_is_media_signin', true );
				update_user_meta( $user_id, 'ulz_media_signin', 'facebook' );

				// get option role
				$role = get_option('ulz_default_user_role');
				if( ! in_array( $role, [ 'customer', 'business' ] ) ) {
					$role = 'customer';
				}

				// set role
				add_user_meta( $user_id, 'ulz_role', $role );

				$picture = $request->get('picture');
				if( isset( $picture['data'] ) && isset( $picture['data']['url'] ) ) {

					$remote = wp_remote_get( $picture['data']['url'], [
						'timeout' => 8
					]);

					if( ! is_wp_error( $remote ) ) {

						$body = wp_remote_retrieve_body( $remote );
						$upload = wp_upload_bits( sprintf( '%s.jpg', $request->get('id') ), null, $body );
						$attach_id = wp_insert_attachment(
							[
								'guid' => $upload['url'],
								'post_mime_type' => 'image/jpeg',
								'post_title' => $request->get('id')
							],
							$upload['file']
						);

						require_once( ABSPATH . 'wp-admin/includes/image.php' );
						wp_generate_attachment_metadata( $attach_id, $upload['file'] );

						if( ! is_wp_error( $attach_id ) ) {
							// update_post_meta( $attach_id, 'ulz_attach_by_media', true );
							// update_user_meta( $user_id, 'ulz_media_picture', $attach_id );
							update_user_meta( $user_id, 'user_avatar', "[{\"id\":{$attach_id}}]" );
						}
					}
				}
			}

	        wp_clear_auth_cookie();

	        $signon = wp_signon([
				'user_login' => $request->get('id'),
				'user_password' => md5( $request->get('id') . get_option('ulz_facebook_app_secret') ),
				'remember' => true,
			], false );

	        if( ! is_wp_error( $signon ) ) {

				// wp_set_current_user( $signon->ID );
				// wp_set_auth_cookie( $signon->ID );
	            // do_action('set_current_user');

				wp_send_json([
					'success' => true,
				]);

	        }

		}

		wp_send_json( $response );

	}

}
